﻿--[[

-- Atlas Data (Traditional Chinese)
-- Translated and maintained by Arith Hsu
-- arithmandarjp at yahoo.co.jp
-- Special thanks for Alfred and his website "Alfred's WoW Treasure BOX"
-- http://statue.sayya.org/wowdb/index.php
--
-- Last Updated: 8/09/2007

--]]
--if (GetLocale() == 	"zhTW") then

--[[
constants.en.lua
This file defines an AceLocale table for all the various text strings needed
by AtlasLoot.  In this implementation, if a translation is missing, it will fall
back to the English translation.

The ["text"] = true; shortcut can ONLY be used for English (the root translation).
]]

--Table for all data to be inserted into.  Included here as it is the first file loaded
--AtlasLoot_Data = {};

--Create the library instance
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

--Allow reporting of what translations are missing
--AL:EnableDebugging();

--Allow the language to be changed dynamically for debugging purposes
--AL:EnableDynamicLocales();

--Register translations
AL:RegisterTranslations("zhTW", function() return {
    --Text strings for UI objects
    ["AtlasLoot"] = "AtlasLoot",
    ["No match found for"] = "找不到符合於",
    ["Search"] = "搜尋",
    ["Clear"] = "清除",
    ["Select Loot Table"] = "選擇物品表格",
    ["Select Sub-Table"] = "選擇子表格",
    ["Drop Rate: "] = "掉落機率: ",
    ["DKP"] = "DKP",
    ["Priority:"] = "優先權：",
    ["Click boss name to view loot."] = "點選首領以檢視物品表",
    ["Various Locations"] = "多個地方",
    ["This is a loot browser only.  To view maps as well, install either Atlas or Alphamap."] = "這只是一個物品檢視視窗。如要檢視地圖，請安裝 Atlas 或是 Alphamap。",
    ["Toggle AL Panel"] = "AtlasLoot 面板",
    [" is safe."] = "的連結現在安全了。",
    ["Server queried for "] = "從伺服器查詢物品",
    [".  Right click on any other item to refresh the loot page."] = "的資訊. 右鍵點選其他物品以更新這一個物品頁面",
    ["Back"] = "返回",
    ["Level 60"] = "60級",
    ["Level 70"] = "70級",
    ["|cffff0000(unsafe)"] = "|cffff0000(不安全)",
    ["Misc"] = "雜項",
    ["Rewards"] = "獎勵",
    ["Heroic Mode"] = "英雄模式",
    ["Normal Mode"] = "一般模式",
    ["Raid"] = "團隊",
    ["Factions - Azeroth"] = "陣營 - 艾澤拉斯",
    ["Factions - Outland"] = "陣營 - 外域",
    ["Factions - Shattrath City"] = "陣營 - 薩塔斯城",
    ["Pre-Burning Crusade"] = "燃燒遠征前",
    ["Post-Burning Crusade"] = "燃燒遠征後",
    ["Choose Table ..."] = "選擇表格 ...",
    ["Close Menu"] = "關閉選單",
    
    --Text for Options Panel
    ["Atlasloot Options"] = "Atlasloot 選項",
    ["Safe Chat Links |cff1eff00(recommended)|r"] = "安全物品連結|cff1eff00（建議）|r",
    ["Enable all Chat Links |cffff0000(use at own risk)|r"] = "使用所有連結|cffff0000（可能導致斷線!）|r",
    ["Default Tooltips"] = "預設提示",
    ["Lootlink Tooltips"] = "Lootlink提示",
    ["|cff9d9d9dLootlink Tooltips|r"] = "|cff9d9d9dLootlink 提示|r",
    ["ItemSync Tooltips"] = "ItemSync 提示",
    ["|cff9d9d9dItemSync Tooltips|r"] = "|cff9d9d9dItemSync 提示|r",
    ["Use EquipCompare"] = "使用 EquipCompare",
    ["|cff9d9d9dUse EquipCompare|r"] = "|cff9d9d9d使用 EquipCompare|r",
    ["Show Comparison Tooltips"] = "顯示物品比較提示訊息",
    ["Make Loot Table Opaque"] = "使物品掉落表不透明",
    ["Show itemIDs at all times"] = "顯示物品ID",
    ["Hide AtlasLoot Panel"] = "隱藏 AtlasLoot 面板",
    ["Show Minimap Button"] = "顯示小地圖按鍵",
    ["Set Minimap Button Position"] = "設定小地圖按鍵位置",
    ["Suppress text spam when querying items"] = "關閉物品查詢提示",
    ["Done"] = "完成",
    
    --Error Messages and warnings
    ["AtlasLoot Error!"] = "AtlasLoot 錯誤!",
    --Incomplete Table Registry error message
    [" not listed in loot table registry, please report this message to the AtlasLoot forums at http://www.atlasloot.net"] = "並未列於物品掉落註冊表，請至Atlasloot論壇回報問題：http://www.atlasloot.net",
    --LoD Module disabled or missing
    [" is unavailable, the following load on demand module is required: "] = "無法取得，需要以下的隨選載入模組：",
    --LoD Module load sequence could not be completed
    ["Status of the following module could not be determined: "] = "以下模組的狀態無法被確認：",
    --LoD Module required has loaded, but loot table is missing
    [" could not be accessed, the following module may be out of date: "] = "無法被存取，以下的模組可能版本已過於老舊：",
    --LoD module loaded successfully
    ["sucessfully loaded."] = "載入成功",
    --Need a big dataset for searching
    ["Loading available tables for searching"] = "載入搜尋所需的資料表",
    
    --Minimap Button
    ["|cff1eff00Left-Click|r Browse Loot Tables"] = "|cff1eff00左鍵|r 瀏覽物品掉落表",
    ["|cffff0000Right-Click|r View Options"] = "|cffff0000右鍵|r 檢視選項",
    ["|cffff0000Shift-Click|r View Options"] = "|cffff0000Shift點擊|r 檢視選項",
    ["|cffccccccLeft-Click + Drag|r Move Minimap Button"] = "|cffccccccLeft-Click + Drag|r Move Minimap Button",
    
    --AtlasLoot Panel
    ["Options"] = "選項",
    ["Collections"] = "套裝/特殊物品",
    ["Factions"] = "陣營",
    
    --First time user
    ["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences for tooltips and links in the chat window.\n\n  This options screen can be reached again at any later time by typing '/atlasloot'."] = "歡迎使用 AtlasLoot Enhanced. 請花一點時間來設定訊息提示和連結的喜好. 輸入 /atlasloot 可以再次設定喜好選項",
    ["Setup"] = "設定",
    
    --Old Atlas Detected
    ["It has been detected that your version of Atlas does not match the version that Atlasloot is tuned for ("] = "您現在的 Atlas 插件版本並不完全支援此版本的 Atlasloot, Atlas 的最新版本為 (",
    [").  Depending on changes, there may be the occasional error, so please visit http://www.atlasmod.com as soon as possible to update."] = "). 依 Atlas 版本的變化, AtlasLoot 也許會出現偶然的錯誤, 請儘快前往 http://www.atlasmod.com 更新",
    ["OK"] = "OK",
    ["Incompatible Atlas Detected"] = "偵測到不相容的Atlas版本",
    
    --Unsafe item tooltip
    ["Unsafe Item"] = "不安全的物品",
    ["ItemID:"] = "物品ID:",
    ["This item is unsafe.  To view this item without the risk of disconnection, you need to have first seen it in the game world. This is a restriction enforced by Blizzard since Patch 1.10."] = "這個物品並不安全. 如要安全的檢視這個物品並且避免斷線, 你必須在當前的伺服器中曾見過該物品. 這是暴雪自 1.10 更新之後增加的限制.",
    ["You can right-click to attempt to query the server.  You may be disconnected."] = "你可以按下滑鼠右鍵來嘗試向伺服器查詢該物品的資訊, 然而你將可能因此斷線.",
    
    --Misc Inventory related words
    ["Mount"] = "坐騎",
    ["Enchant"] = "公式",
    ["Trade Goods"] = "商品",
    ["Scope"] = "瞄準鏡",
    ["Pet"] = "寵物",
    ["Darkmoon Faire Card"] = "暗月卡",
    ["Book"] = "書籍",
    ["Banner"] = "軍旗",
    ["Set"] = "套裝",
    ["Token"] = "勳章",
    ["Crafting Reagent"] = "卷軸圖樣",
    ["Skinning Knife"] = "剝皮小刀",
    ["Herbalism Knife"] = "草藥刀",
    ["Fishing Pole"] = "魚竿",
    ["Fish"] = "釣魚",

    --Labels for loot descriptions
    ["Classes:"] = "職業:",
    ["This Item Begins a Quest"] = "該物品將觸發一個任務",
    ["Quest Item"] = "任務物品",
    ["Quest Reward"] = "任務獎勵",
    ["Shared"] = "隨機掉落",
    ["Unique"] = "唯一",
    ["Right Half"] = "右半部份",
    ["Left Half"] = "左半部份",
    ["28 Slot Soul Shard"] = "28 格靈魂袋",
    ["18 Slot"] = "18格容器",
    ["16 Slot"] = "16格容器",
    ["10 Slot"] = "10格容器",
    ["(has random enchantment)"] = "(具有隨機屬性)",
    ["Use to purchase rewards"] = "用以兌換獎勵",
    ["Use to purchase rewards (Horde)"] = "用以兌換獎勵 (部落)",
    ["Use to purchase rewards (Alliance)"] = "用以兌換獎勵 (聯盟)",
    ["World Bosses"] = "世界首領",
    ["Reputation Factions"] = "聲望獎勵",
    ["Sets/Collections"] = "套裝/特殊物品",
    ["Card Game Item"] = "卡片遊戲物品",
    ["Tier 4"] = "T4",
    ["Tier 5"] = "T5",
    ["Tier 6"] = "T6",
    ["Arena Reward"] = "競技場獎勵", 
    ["Conjured Item"] = "特殊物品", 
    ["Used to summon boss"] = "使用以召喚首領", 

    ["Phase 1"] = "第一階段", 
    ["Phase 2"] = "第二階段", 
    ["Phase 3"] = "第三階段", 
    ["Fire"] = "火", 
    ["Water"] = "水", 
    ["Wind"] = "風", 
    ["Earth"] = "土", 
    ["Master Angler"] = "釣魚大師", 
    ["First Prize"] = "頭獎", 
    ["Rare Fish Rewards"] = "稀有釣魚獎勵", 

    --Card Game Decks and descriptions
    ["Upper Deck Card Game Items"] = "Upper Deck 卡片遊戲物品",
    ["Heroes of Azeroth"] = "艾澤拉斯英雄",
    ["Through The Dark Portal"] = "通過黑暗之門",
    ["Fires of Outland"] = "外域之火",
    ["Loot Card Items"] = "可換取的物品", 
    ["UDE Items"] = "UDE 物品",
    ["Landro Longshot"] = "藍卓",
    ["Thunderhead Hippogryph"] = "雷首角鷹獸",
    ["Saltwater Snapjaw"] = "海水鉗嘴龜",
    ["King Mukla"] = "穆克拉",
    ["Rest and Relaxation"] = "休息和放鬆",
    ["Fortune Telling"] = "算命",

    --Special loot categories for Battlegrounds
    ["Misc. Rewards"] = "雜項獎勵",
    ["Superior Rewards"] = "精良獎勵",
    ["Epic Rewards"] = "史詩獎勵",
    
    --Brood of Nozdormu Paths
    ["Path of the Conqueror"] = "征服者之路",
    ["Path of the Invoker"] = "祈求者之路",
    ["Path of the Protector"] = "保護者之路",
    
    --Violet Eye Paths
    ["Path of the Violet Protector"] = "紫羅蘭保衛者之路",
    ["Path of the Violet Mage"] = "紫蘿蘭法師之路",
    ["Path of the Violet Assassin"] = "紫羅蘭刺客之路",
    ["Path of the Violet Restorer"] = "紫羅蘭治療師之路",
    
    --AQ Opening Event
    ["Red Scepter Shard"] = "紅色權杖碎片",
    ["Blue Scepter Shard"] = "藍色權杖碎片",
    ["Green Scepter Shard"] = "綠色權杖碎片",
    ["Scepter of the Shifting Sands"] = "流沙權杖",
    
    --World PvP
    ["Hellfire Fortifications"] = "地獄火防禦堡壘", 
    ["Twin Spire Ruins"] = "雙塔廢墟",
    ["Spirit Towers"] = "精神哨塔",
    ["Halaa"] = "哈剌",
    
    --Karazhan Opera Event Headings
    ["Shared Drops"] = "隨機掉落",
    ["Romulo & Julianne"] = "Romulo & Julianne",
    ["Wizard of Oz"] = "綠野仙蹤",
    ["Red Riding Hood"] = "小紅帽",
    
    --Karazhan Animal Boss Types
    ["Spider"] = "蜘蛛",
    ["Darkhound"] = "黑暗犬",
    ["Bat"] = "蝙蝠",
    
    --ZG Tokens
    ["Primal Hakkari Kossack"] = "原始哈卡萊套索",
    ["Primal Hakkari Shawl"] = "原始哈卡萊披肩",
    ["Primal Hakkari Bindings"] = "原始哈卡萊護腕",
    ["Primal Hakkari Sash"] = "原始哈卡萊腰帶",
    ["Primal Hakkari Stanchion"] = "原始哈卡萊直柱",
    ["Primal Hakkari Aegis"] = "原始哈卡萊之盾",
    ["Primal Hakkari Girdle"] = "原始哈卡萊束帶",
    ["Primal Hakkari Armsplint"] = "原始哈卡萊護臂",
    ["Primal Hakkari Tabard"] = "原始哈卡萊徽章",
    
    --AQ20 Tokens
    ["Qiraji Ornate Hilt"] = "其拉華麗刀柄",
    ["Qiraji Martial Drape"] = "其拉軍用披風",
    ["Qiraji Magisterial Ring"] = "其拉將領戒指",
    ["Qiraji Ceremonial Ring"] = "其拉典禮戒指",
    ["Qiraji Regal Drape"] = "其拉帝王披風",
    ["Qiraji Spiked Hilt"] = "其拉尖刺刀柄",
    
    --AQ40 Tokens
    ["Qiraji Bindings of Dominance"] = "其拉統御腕輪",
    ["Qiraji Bindings of Command"] = "其拉命令腕輪",
    ["Vek'nilash's Circlet"] = "維克尼拉斯的頭飾",
    ["Vek'lor's Diadem"] = "維克洛爾的王冠",
    ["Ouro's Intact Hide"] = "奧羅的外皮",
    ["Skin of the Great Sandworm"] = "巨型沙蟲的皮",
    ["Husk of the Old God"] = "上古之神的外殼",
    ["Carapace of the Old God"] = "上古之神的甲殼",

    --Blacksmithing Crafted Sets
    ["Imperial Plate"] = "君王鎧甲",
    ["The Darksoul"] = "黑暗之魂",
    ["Fel Iron Plate"] = "魔鐵鎧甲",
    ["Adamantite Battlegear"] = "堅鋼戰甲",
    ["Flame Guard"] = "烈焰套裝",
    ["Enchanted Adamantite Armor"] = "附魔堅鋼護甲",
    ["Khorium Ward"] = "克銀結界",
    ["Faith in Felsteel"] = "信仰魔鋼",
    ["Burning Rage"] = "燃燒狂怒",
    ["Bloodsoul Embrace"] = "血魂的擁抱",
    ["Fel Iron Chain"] = "魔鐵鍊甲",

    --Tailoring Crafted Sets
    ["Bloodvine Garb"] = "血藤之服",
    ["Netherweave Vestments"] = "幽紋套裝",
    ["Imbued Netherweave"] = "韌化幽紋套裝",
    ["Arcanoweave Vestments"] = "奧紋套裝",
    ["The Unyielding"] = "頑強套裝",
    ["Whitemend Wisdom"] = "白癒智慧",
    ["Spellstrike Infusion"] = "法擊套裝",
    ["Battlecast Garb"] = "戰放服裝",
    ["Soulcloth Embrace"] = "靈魂布的擁抱",
    ["Primal Mooncloth"] = "原始月布",
    ["Shadow's Embrace"] = "暗影的擁抱",
    ["Wrath of Spellfire"] = "魔焰之怒",

    --Leatherworking Crafted Sets
    ["Volcanic Armor"] = "火山護甲",
    ["Ironfeather Armor"] = "鐵羽護甲",
    ["Stormshroud Armor"] = "雷暴護甲",
    ["Devilsaur Armor"] = "魔暴龍護甲",
    ["Blood Tiger Harness"] = "血虎套索",
    ["Primal Batskin"] = "原始蝙蝠皮套裝",
    ["Wild Draenish Armor"] = "狂野德萊尼護甲",
    ["Thick Draenic Armor"] = "厚德萊尼護甲",
    ["Fel Skin"] = "惡魔皮膚",
    ["Strength of the Clefthoof"] = "裂蹄力量", 
    ["Green Dragon Mail"] = "綠龍鎖甲",
    ["Blue Dragon Mail"] = "藍龍鎖甲",
    ["Black Dragon Mail"] = "黑龍鎖甲",
    ["Scaled Draenic Armor"] = "德萊尼鱗護甲",
    ["Felscale Armor"] = "魔鱗護甲",
    ["Felstalker Armor"] = "惡魔捕獵者套裝",
    ["Fury of the Nether"] = "虛空之怒套裝",
    ["Primal Intent"] = "原始之意套裝",
    ["Windhawk Armor"] = "風之隼護甲",
    ["Netherscale Armor"] = "地獄鱗護甲",
    ["Netherstrike Armor"] = "地擊套裝",

    --Pre-60 Sets
    ["Defias Leather"] = "迪菲亞皮甲",
    ["Embrace of the Viper"] = "毒蛇的擁抱",
    ["Chain of the Scarlet Crusade"] = "血色十字軍鏈甲",
    ["The Gladiator"] = "角鬥士套裝",
    ["Ironweave Battlesuit"] = "鐵織戰裝",
    ["Necropile Raiment"] = "骨堆套裝",
    ["Cadaverous Garb"] = "蒼白套裝",
    ["Bloodmail Regalia"] = "血鏈套裝",
    ["Deathbone Guardian"] = "亡骨守護者",
    ["The Postmaster"] = "郵差套裝",
    ["Scourge Invasion"] = "天譴軍團",
    ["Regalia of Undead Cleansing"] = "淨妖套裝",
    ["Undead Slayer's Armor"] = "不死弒者的護甲",
    ["Garb of the Undead Slayer"] = "不死弒者的裝束",
    ["Battlegear of Undead Slaying"] = "弒妖套裝",
    ["Shard of the Gods"] = "天神碎片",
    ["Zul'Gurub Rings"] = "祖爾格拉布套戒",
    ["Major Mojo Infusion"] = "極效魔精套裝",
    ["Overlord's Resolution"] = "督軍的決心",
    ["Prayer of the Primal"] = "遠古祈禱文",
    ["Zanzil's Concentration"] = "贊吉爾的專注",
    ["Spirit of Eskhandar"] = "艾斯卡達爾之魂",
    ["The Twin Blades of Hakkari"] = "哈卡萊雙刃",
    ["Primal Blessing"] = "原始祝福",
    ["Dal'Rend's Arms"] = "雷德雙刀",
    ["Spider's Kiss"] = "蜘蛛之吻",

    --BC Sets
    ["The Twin Stars"] = "雙子星套裝",
    ["The Twin Blades of Azzinoth"] = "埃辛諾斯雙刃",

    --ZG Sets
    ["Haruspex's Garb"] = "占卜師套裝",
    ["Predator's Armor"] = "捕獵者套裝",
    ["Illusionist's Attire"] = "幻術師套裝",
    ["Freethinker's Armor"] = "思考者護甲",
    ["Confessor's Raiment"] = "懺悔者衣飾",
    ["Madcap's Outfit"] = "狂妄者套裝",
    ["Augur's Regalia"] = "預言者套裝",
    ["Demoniac's Threads"] = "惡魔師護甲",
    ["Vindicator's Battlegear"] = "辯護者重甲",

    --AQ20 Sets
    ["Symbols of Unending Life"] = "不滅生命套裝",
    ["Trappings of the Unseen Path"] = "隱秘通途套裝",
    ["Trappings of Vaulted Secrets"] = "魔法祕密套裝",
    ["Battlegear of Eternal Justice"] = "永恆公正套裝",
    ["Finery of Infinite Wisdom"] = "無盡智慧套裝",
    ["Emblems of Veiled Shadows"] = "籠罩陰影套裝",
    ["Gift of the Gathering Storm"] = "聚集風暴套裝",
    ["Implements of Unspoken Names"] = "禁斷邪語套裝",
    ["Battlegear of Unyielding Strength"] = "堅定力量套裝",

    --AQ40 Sets
    ["Genesis Raiment"] = "起源套裝",
    ["Striker's Garb"] = "攻擊者",
    ["Enigma Vestments"] = "神祕套裝", 
    ["Avenger's Battlegear"] = "復仇者",
    ["Garments of the Oracle"] = "神諭者套裝",
    ["Deathdealer's Embrace"] = "死亡執行者",
    ["Stormcaller's Garb"] = "風暴召喚者",
    ["Doomcaller's Attire"] = "厄運召喚者",
    ["Conqueror's Battlegear"] = "征服者戰甲",

    --Dungeon 1 Sets
    ["Wildheart Raiment"] = "野性之心",
    ["Beaststalker Armor"] = "馭獸者",
    ["Magister's Regalia"] = "博學者的徽記",
    ["Lightforge Armor"] = "光鑄護甲",
    ["Vestments of the Devout"] = "虔誠",
    ["Shadowcraft Armor"] = "迅影",
    ["The Elements"] = "元素",
    ["Dreadmist Raiment"] = "鬼霧",
    ["Battlegear of Valor"] = "勇氣戰甲",

    --Dungeon 2 Sets
    ["Feralheart Raiment"] = "獸心外衣",
    ["Beastmaster Armor"] = "獸王護甲", 
    ["Sorcerer's Regalia"] = "女巫徽記",
    ["Soulforge Armor"] = "靈魂鍛造護甲",
    ["Vestments of the Virtuous"] = "正直外衣",
    ["Darkmantle Armor"] = "闇影護甲",
    ["The Five Thunders"] = "五雷霆",
    ["Deathmist Raiment"] = "死亡迷霧外衣",
    ["Battlegear of Heroism"] = "英雄的裝備",

    --Dungeon 3 Sets
    ["Hallowed Raiment"] = "神聖儀祭衣飾套裝",
    ["Incanter's Regalia"] = "魔法使的外衣套裝",
    ["Mana-Etched Regalia"] = "法力蝕刻戰衣套裝",
    ["Oblivion Raiment"] = "失落戰衣套裝",
    ["Assassination Armor"] = "暗殺套裝",
    ["Moonglade Raiment"] = "月光林地套裝",
    ["Wastewalker Armor"] = "荒行套裝",
    ["Beast Lord Armor"] = "野獸之王護甲",
    ["Desolation Battlegear"] = "哀傷之鏈套裝",
    ["Tidefury Raiment"] = "惡潮套裝",
    ["Bold Armor"] = "勇猛護甲套裝",
    ["Doomplate Battlegear"] = "末日戰甲套裝",
    ["Righteous Armor"] = "公正護甲",

    --Tier 1 Sets
    ["Cenarion Raiment"] = "塞納里奧",
    ["Giantstalker Armor"] = "巨獸之王",
    ["Arcanist Regalia"] = "祕法師",
    ["Lawbringer Armor"] = "秩序之源",
    ["Vestments of Prophecy"] = "預言",
    ["Nightslayer Armor"] = "夜幕殺手",
    ["The Earthfury"] = "大地之怒",
    ["Felheart Raiment"] = "惡魔之心",
    ["Battlegear of Might"] = "力量",

    --Tier 2 Sets
    ["Stormrage Raiment"] = "怒風",
    ["Dragonstalker Armor"] = "馭龍者",
    ["Netherwind Regalia"] = "靈風",
    ["Judgement Armor"] = "審判",
    ["Vestments of Transcendence"] = "卓越",
    ["Bloodfang Armor"] = "血牙",
    ["The Ten Storms"] = "無盡風暴",
    ["Nemesis Raiment"] = "復仇",
    ["Battlegear of Wrath"] = "憤怒戰甲",

    --Tier 3 Sets
    ["Dreamwalker Raiment"] = "夢行者套裝",
    ["Cryptstalker Armor"] = "地穴行者護甲",
    ["Frostfire Regalia"] = "霜火套裝",
    ["Redemption Armor"] = "救贖套裝",
    ["Vestments of Faith"] = "信仰套裝",
    ["Bonescythe Armor"] = "骨鐮套裝",
    ["The Earthshatterer"] = "粉碎大地護甲", 
    ["Plagueheart Raiment"] = "瘟疫之心套裝",
    ["Dreadnaught's Battlegear"] = "無畏套裝",

    --Tier 4 Sets
    ["Malorne Harness"] = "瑪洛尼戰甲套裝",
    ["Malorne Raiment"] = "瑪洛尼儀祭皮甲套裝",
    ["Malorne Regalia"] = "瑪洛尼戰衣套裝",
    ["Demon Stalker Armor"] = "惡魔獵者套裝",
    ["Aldor Regalia"] = "奧多爾戰衣套裝",
    ["Justicar Armor"] = "審判者防禦套裝",
    ["Justicar Battlegear"] = "審判者戰鬥套裝",
    ["Justicar Raiment"] = "審判者神聖套裝",
    ["Incarnate Raiment"] = "聖軀儀祭衣飾套裝",
    ["Incarnate Regalia"] = "聖軀戰衣套裝", 
    ["Netherblade Set"] = "地獄之刃套裝",
    ["Cyclone Harness"] = "暴風護甲套裝", 
    ["Cyclone Raiment"] = "暴風儀祭鎖甲套裝",
    ["Cyclone Regalia"] = "暴風戰衣套裝",
    ["Voidheart Raiment"] = "空虛之心戰衣",
    ["Warbringer Armor"] = "戰爭使者防禦套裝",
    ["Warbringer Battlegear"] = "戰爭使者戰甲套裝",

    --Tier 5 Sets
    ["Nordrassil Harness"] = "諾達希爾戰甲套裝",
    ["Nordrassil Raiment"] = "諾達希爾儀祭之服套裝",
    ["Nordrassil Regalia"] = "諾達希爾戰衣套裝",
    ["Rift Stalker Armor"] = "裂隙行者護甲套裝",
    ["Tirisfal Regalia"] = "提里斯法戰衣套裝",
    ["Crystalforge Armor"] = "晶鑄防禦套裝",
    ["Crystalforge Battlegear"] = "晶鑄戰甲套裝",
    ["Crystalforge Raiment"] = "晶鑄神聖套裝",
    ["Avatar Raiment"] = "化身儀祭衣飾套裝", 
    ["Avatar Regalia"] = "化身戰衣套裝",
    ["Deathmantle Set"] = "死神傳承套裝", 
    ["Cataclysm Harness"] = "裂地護甲套裝",
    ["Cataclysm Raiment"] = "裂地儀祭鎖甲套裝",
    ["Cataclysm Regalia"] = "裂地戰衣套裝",
    ["Corruptor Raiment"] = "墮落戰衣",
    ["Destroyer Armor"] = "毀滅者護甲套裝",
    ["Destroyer Battlegear"] = "毀滅者套裝",

    --Tier 6 Sets
    ["Thunderheart Harness"] = "雷霆之心戰甲套裝",
    ["Thunderheart Raiment"] = "雷霆之心儀祭之服套裝",
    ["Thunderheart Regalia"] = "雷霆之心戰衣套裝",
    ["Gronnstalker's Armor"] = "古羅行者套裝",
    ["Tempest Regalia"] = "風暴戰衣",
    ["Lightbringer Armor"] = "光明使者戰甲套裝",
    ["Lightbringer Battlegear"] = "光明使者護甲套裝",
    ["Lightbringer Raiment"] = "光明使者聖甲套裝",
    ["Vestments of Absolution"] = "赦免祭袍套裝", 
    ["Absolution Regalia"] = "赦免戰衣套裝", 
    ["Slayer's Armor"] = "屠殺者護甲套裝",
    ["Skyshatter Harness"] = "碎天者戰甲套裝",
    ["Skyshatter Raiment"] = "碎天者儀祭鎖甲套裝",
    ["Skyshatter Regalia"] = "碎天者戰衣套裝",
    ["Malefic Raiment"] = "邪惡戰衣套裝",
    ["Onslaught Armor"] = "突擊護甲",
    ["Onslaught Battlegear"] = "突擊戰甲",

    --Arathi Basin Sets - Alliance
    ["The Highlander's Intent"] = "高地人的專注",
    ["The Highlander's Purpose"] = "高地人的毅力",
    ["The Highlander's Will"] = "高地人的意志",
    ["The Highlander's Determination"] = "高地人的果斷",
    ["The Highlander's Resolve"] = "高地人的執著",
    ["The Highlander's Resolution"] = "高地人的決心",
    
    --Arathi Basin Sets - Horde
    ["The Defiler's Intent"] = "污染者的專注",
    ["The Defiler's Purpose"] = "污染者的毅力",
    ["The Defiler's Will"] = "污染者的意志",
    ["The Defiler's Determination"] = "污染者的果斷",
    ["The Defiler's Fortitude"] = "污染者的堅韌",
    ["The Defiler's Resolution"] = "污染者的決心",

    --PvP Level 60 Rare Sets - Alliance
    ["Lieutenant Commander's Refuge"] = "中尉指揮官的庇護",
    ["Lieutenant Commander's Pursuance"] = "中尉指揮官的追求",
    ["Lieutenant Commander's Arcanum"] = "中尉指揮官的奧祕",
    ["Lieutenant Commander's Redoubt"] = "中尉指揮官的防禦",
    ["Lieutenant Commander's Investiture"] = "中尉指揮官的服裝",
    ["Lieutenant Commander's Guard"] = "中尉指揮官的防護",
    ["Lieutenant Commander's Stormcaller"] = "中尉指揮官的風暴召喚者",
    ["Lieutenant Commander's Dreadgear"] = "中尉指揮官的裝備",
    ["Lieutenant Commander's Battlearmor"] = "中尉指揮官的戰甲", 

    --PvP Level 60 Rare Sets - Horde
    ["Champion's Refuge"] = "勇士的聖裝",
    ["Champion's Pursuance"] = "勇士的追求",
    ["Champion's Arcanum"] = "勇士的奧祕",
    ["Champion's Redoubt"] = "勇士的壁壘",
    ["Champion's Investiture"] = "勇士的服裝",
    ["Champion's Guard"] = "勇士的外衣",
    ["Champion's Stormcaller"] = "勇士的召喚", 
    ["Champion's Dreadgear"] = "勇士的護甲",
    ["Champion's Battlearmor"] = "勇士的戰甲",
   
    --PvP Level 60 Epic Sets - Alliance
    ["Field Marshal's Sanctuary"] = "戰場元帥的聖裝",
    ["Field Marshal's Pursuit"] = "戰場元帥的獵裝",
    ["Field Marshal's Regalia"] = "戰場元帥的法衣", 
    ["Field Marshal's Aegis"] = "戰場元帥的庇護",
    ["Field Marshal's Raiment"] = "戰場元帥的神服",
    ["Field Marshal's Vestments"] = "戰場元帥的制服",
    ["Field Marshal's Earthshaker"] = "戰場元帥的地者",
    ["Field Marshal's Threads"] = "戰場元帥的魔裝",
    ["Field Marshal's Battlegear"] = "戰場元帥的戰甲",

    --PvP Level 60 Epic Sets - Horde
    ["Warlord's Sanctuary"] = "督軍的聖裝",
    ["Warlord's Pursuit"] = "督軍的獵裝", 
    ["Warlord's Regalia"] = "督軍的法衣套裝",
    ["Warlord's Aegis"] = "督軍的庇護",
    ["Warlord's Raiment"] = "督軍的祭祀袍套裝",
    ["Warlord's Vestments"] = "督軍的制服",
    ["Warlord's Earthshaker"] = "督軍的震地者套裝",
    ["Warlord's Threads"] = "督軍的魔裝",
    ["Warlord's Battlegear"] = "督軍的戰甲",

    --PvP Level 70 Rare Sets - Alliance
    ["Grand Marshal's Sanctuary"] = "總元帥的聖裝",
    ["Grand Marshal's Wildhide"] = "總元帥的狂野革甲套裝",
    ["Grand Marshal's Refuge"] = "總元帥的庇護套裝",
    ["Grand Marshal's Pursuit"] = "總元帥的獵裝",
    ["Grand Marshal's Regalia"] = "總元帥的禮服",
    ["Grand Marshal's Aegis"] = "總元帥的庇護之盾",
    ["Grand Marshal's Vindication"] = "總元帥的辯護",
    ["Grand Marshal's Redemption"] = "總元帥的救贖套裝",
    ["Grand Marshal's Raiment"] = "總元帥的祭祀袍套裝",
    ["Grand Marshal's Investiture"] = "總元帥的傳承套裝",
    ["Grand Marshal's Vestments"] = "總元帥的制服",
    ["Grand Marshal's Earthshaker"] = "總元帥的震地者",
    ["Grand Marshal's Thunderfist"] = "總元帥的雷霆之拳套裝",
    ["Grand Marshal's Wartide"] = "總元帥的戰鬥之潮套裝",
    ["Grand Marshal's Dreadgear"] = "總元帥的戰慄套裝",
    ["Grand Marshal's Battlegear"] = "總元帥的戰甲套裝",

    --PvP Level 70 Rare Sets - Horde
    ["High Warlord's Sanctuary"] = "高階督軍的聖裝",
    ["High Warlord's Wildhide"] = "高階督軍的狂野革甲套裝",
    ["High Warlord's Refuge"] = "高階督軍的庇護套裝",
    ["High Warlord's Pursuit"] = "高階督軍的獵裝",
    ["High Warlord's Regalia"] = "高階督軍的禮服",
    ["High Warlord's Aegis"] = "高階督軍的庇護",
    ["High Warlord's Vindication"] = "高階督軍的辯護",
    ["High Warlord's Redemption"] = "高階督軍的救贖套裝",
    ["High Warlord's Raiment"] = "高階督軍的祭祀袍套裝",
    ["High Warlord's Investiture"] = "高階督軍的傳承套裝",
    ["High Warlord's Vestments"] = "高階督軍的制服",
    ["High Warlord's Earthshaker"] = "高階督軍的震地者",
    ["High Warlord's Thunderfist"] = "高階督軍的雷霆之拳套裝", 
    ["High Warlord's Wartide"] = "高階督軍的戰鬥之潮套裝", 
    ["High Warlord's Dreadgear"] = "高階督軍的戰慄套裝",
    ["High Warlord's Battlegear"] = "高階督軍的戰甲",

    --Arena Season 1 - Epic Sets
    ["Gladiator's Sanctuary"] = "鬥士的聖裝",
    ["Gladiator's Wildhide"] = "鬥士的狂野革甲套裝", 
    ["Gladiator's Refuge"] = "鬥士的庇護套裝",
    ["Gladiator's Pursuit"] = "鬥士的獵裝",
    ["Gladiator's Regalia"] = "鬥士的戰衣套裝",
    ["Gladiator's Aegis"] = "鬥士的聖禦戰甲", 
    ["Gladiator's Vindication"] = "鬥士的辯護套裝",
    ["Gladiator's Redemption"] = "鬥士的救贖套裝",
    ["Gladiator's Raiment"] = "鬥士的儀祭服套裝",
    ["Gladiator's Investiture"] = "鬥士的傳承套裝",
    ["Gladiator's Vestments"] = "鬥士的戰鬥皮甲",
    ["Gladiator's Earthshaker"] = "鬥士的震地者套裝",
    ["Gladiator's Thunderfist"] = "鬥士的雷霆之拳套裝",
    ["Gladiator's Wartide"] = "鬥士的戰鬥之潮套裝",
    ["Gladiator's Dreadgear"] = "角鬥士裝備",
    ["Gladiator's Felshroud"] = "鬥士的魔化外衣套裝",
    ["Gladiator's Battlegear"] = "角鬥士戰甲",

    --Arena Season 2 - Epic Sets
    ["Merciless Gladiator's Sanctuary"] = "殘忍鬥士的聖裝",
    ["Merciless Gladiator's Wildhide"] = "殘忍鬥士的狂野革甲套裝",
    ["Merciless Gladiator's Refuge"] = "殘忍鬥士的庇護套裝",
    ["Merciless Gladiator's Pursuit"] = "殘忍鬥士的獵裝",
    ["Merciless Gladiator's Regalia"] = "殘忍鬥士的戰衣套裝",
    ["Merciless Gladiator's Aegis"] = "殘忍鬥士的防護套裝",
    ["Merciless Gladiator's Vindication"] = "殘忍鬥士的懲戒裝甲",
    ["Merciless Gladiator's Redemption"] = "殘忍鬥士的救贖套裝",
    ["Merciless Gladiator's Raiment"] = "殘忍鬥士的神聖套裝",
    ["Merciless Gladiator's Investiture"] = "殘忍鬥士的傳承套裝",
    ["Merciless Gladiator's Vestments"] = "殘忍鬥士的戰鬥皮甲",
    ["Merciless Gladiator's Earthshaker"] = "殘忍鬥士的震地者套裝",
    ["Merciless Gladiator's Thunderfist"] = "殘忍鬥士的雷霆之拳套裝",
    ["Merciless Gladiator's Wartide"] = "殘忍鬥士的戰鬥之潮套裝",
    ["Merciless Gladiator's Dreadgear"] = "殘忍鬥士的戰慄套裝",
    ["Merciless Gladiator's Felshroud"] = "殘忍鬥士的魔化外衣套裝",
    ["Merciless Gladiator's Battlegear"] = "殘忍鬥士的戰甲套裝",
    
    --Set Labels
    ["Set: Embrace of the Viper"] = "套裝:毒蛇的擁抱",
    ["Set: Defias Leather"] = "套裝:迪菲亞皮甲",
    ["Set: The Gladiator"] = "套裝:角鬥士",
    ["Set: Chain of the Scarlet Crusade"] = "套裝:血色十字軍鏈甲",
    ["Set: The Postmaster"] = "郵差套裝",
    ["Set: Necropile Raiment"] = "骨堆套裝",
    ["Set: Cadaverous Garb"] = "蒼白套裝",
    ["Set: Bloodmail Regalia"] = "血鏈套裝",
    ["Set: Deathbone Guardian"] = "亡骨守護者套裝",
    ["Set: Dal'Rend's Arms"] = "雷德雙刀",
    ["Set: Spider's Kiss"] = "蜘蛛之吻",
    ["Temple of Ahn'Qiraj Sets"] = "安其拉神廟套裝",
    ["AQ40 Class Sets"] = "AQ40 職業套裝",
    ["Ruins of Ahn'Qiraj Sets"] = "安其拉廢墟套裝",
    ["AQ20 Class Sets"] = "AQ20 職業套裝",
    ["AQ Enchants"] = "AQ 公式",
    ["AQ Opening Quest Chain"] = "安其拉開門系列任務",
    ["Pre 60 Sets"] = "60級以下套裝",
    ["Crafted Sets"] = "精緻套裝",
    ["Crafted Epic Weapons"] = "鍛造史詩武器",
    ["Zul'Gurub Sets"] = "祖爾格拉布套裝",
    ["ZG Class Sets"] = "ZG 職業套裝",
    ["ZG Enchants"] = "ZG 公式",
    ["Dungeon 1/2 Sets"] = "副本套裝 1-2",
    ["Dungeon 1 Set"] = "副本套裝 1",
    ["Dungeon 2 Set"] = "副本套裝 2", 
    ["Dungeon 3 Sets"] = "副本套裝 3",
    ["Tier 1 Sets"] = "T1 套裝",
    ["Tier 2 Sets"] = "T2 套裝",
    ["Tier 3 Sets"] = "T3 套裝",
    ["Tier 4 Sets"] = "T4 套裝",
    ["Tier 5 Sets"] = "T5 套裝",
    ["Tier 6 Sets"] = "T6 套裝",
    ["PvP Sets (Level 60)"] = "PvP 套裝 (60級)",
    ["PvP Sets (Level 70)"] = "PvP 套裝 (70級)",
    ["PvP Rewards (Level 60)"] = "PvP 獎勵 (60級)",
    ["PvP Rewards (Level 70)"] = "PvP 獎勵 (70級)",
    ["PvP Accessories (Level 60)"] = "PvP 配件 (60級)",
    ["PvP Accessories (Level 70)"] = "PvP 配件 (70級)",
    ["PvP Rewards"] = "PvP 榮譽獎勵",
    ["PvP Armor Sets"] = "PvP 套裝",
    ["PvP Weapons"] = "PvP 武器",
    ["PvP Accessories"] = "PvP 物品",
    ["PvP Non-Set Epics"] = "PvP 非套裝史詩物品",
    ["Arena PvP Sets"] = "競技場 PvP 套裝",
    ["Arena 2 PvP Sets"] = "競技場 PvP 套裝(第二季)",
    ["Arena PvP Weapons"] = "競技場 PvP 武器",
    ["Arena 2 PvP Weapons"] = "競技場 PvP 武器(第二季)",
    ["Season 1"] = "第一季聯賽", 
    ["Season 2"] = "第二季聯賽", 
    ["Arathi Basin Sets"] = "阿拉希盆地套裝",
    ["Class Books"] = "職業技能書",
    ["Tribute Run"] = "貢品",
    ["Dire Maul Books"] = "厄運書籍",
    ["Random Boss Loot"] = "首領隨機掉落",
    ["Class Set Pieces"] = "聲望獎勵裝備",
    ["Epic Set"] = "PvP 史詩套裝",
    ["Rare Set"] = "PvP 稀有套裝",
    ["Legendary Items"] = "傳說物品",
    ["Lvl 70 Instance Token Rewards"] = "70級副本兌換獎勵",
    ["Accesories and Weapons"] = "配件與武器",
    ["Accessories"] = "配件",
    ["Armor and Weapons"] = "裝備與武器",
    ["Fire Resistance Gear"] = "火抗裝備",
    ["Arcane Resistance Gear"] = "祕法抗性裝備",
    ["Nature Resistance Gear"] = "自然抗性裝備",
    ["Frost Resistance Gear"] = "冰霜抗性裝備",
    ["Shadow Resistance Gear"] = "暗影抗性裝備",
    ["Rare Mounts"] = "稀有坐騎",
    ["Tabards"] = "大衣/軍服",
    ["Token Hand-Ins"] = "可兌換的獎勵",
    ["Heroic Mode Keys"] = "英雄模式鑰匙",
    ["Legendary Items for Kael'thas Fight"] = "凱爾薩斯·逐日者史詩物品",
    
    --NPCs missing from BabbleBoss
    ["Trash Mobs"] = "小怪",
    ["Dungeon Set 2 Summonable"] = "T0.5 召喚王",
    ["Highlord Kruul"] = "卡魯歐領主",
    ["Theldren"] = "瑟爾倫", 
    ["Sothos and Jarien"] = "索索斯及賈林",
    ["Isalien"] = "依薩利恩",
    ["Mor Grayhoof"] = "莫爾·灰蹄",
    ["Kormok"] = "科爾莫克 (召喚)",
    ["Druid of the Fang"] = "尖牙德魯伊",
    ["Defias Strip Miner"] = "迪菲亞赤膊礦工",
    ["Defias Overseer/Taskmaster"] = "迪菲亞監工/工頭",
    ["Scarlet Defender/Myrmidon"] = "血色防禦者/血色僕從",
    ["Scarlet Champion"] = "血色勇士",
    ["Scarlet Centurion"] = "血色百夫長",
    ["Scarlet Trainee"] = "血色預備兵",
    ["Herod/Mograine"] = "赫洛德/莫格萊尼",
    ["Scarlet Protector/Guardsman"] = "血色保衛者/血色衛兵",
    ["Eviscerator"] = "剜眼者",
    ["Shadowforge Flame Keeper"] = "暗爐持火者",
    ["Olaf"] = "奧拉夫",
    ["Eric 'The Swift'"] = "埃瑞克",
    ["Shadow of Doom"] = "末日陰影",
    ["Bone Witch"] = "骸骨巫師",
    ["Lumbering Horror"] = "笨拙的憎惡",
    ["Shade of Akama"] = "阿卡瑪的鬼魂",
    ["Essence of Souls"] = "死靈精華",
    ["Illidari Council"] = "伊利達瑞議事",
    ["Avatar of the Martyred"] = "馬丁瑞德的化身",
    ["Yor"] = "約兒",
    ["Anzu"] = "安祖",
    ["Nexus Stalker"] = "奈薩斯捕獵者",
    ["Auchenai Monk"] = "奧奇奈僧侶",
    ["Cabal Fanatic"] = "卡巴狂熱者",
    ["Unchained Doombringer"] = "無束縛的摧毀者",
    ["Crimson Sorcerer"] = "紅衣法術師",
    ["Thuzadin Shadowcaster"] = "圖薩丁暗影施法者",
    ["Crimson Inquisitor"] = "紅衣審查者",
    ["Crimson Battle Mage"] = "紅衣戰鬥法師",
    ["Ghoul Ravener"] = "食屍搶奪者",
    ["Spectral Citizen"] = "鬼魂市民",
    ["Spectral Researcher"] = "鬼靈研究員",
    ["Scholomance Adept"] = "通靈學院專家",
    ["Scholomance Dark Summoner"] = "通靈學院黑暗召喚師",
    ["Blackhand Elite"] = "黑手精英",
    ["Blackhand Assassin"] = "黑手刺客",
    ["Firebrand Pyromancer"] = "火印炎術師",
    ["Firebrand Invoker"] = "火印塑能師",
    ["Firebrand Grunt"] = "火印步兵",
    ["Firebrand Legionnaire"] = "火印軍團戰士",
    ["Spirestone Warlord"] = "尖石軍閥",
    ["Spirestone Mystic"] = "尖石秘法師",
    ["Anvilrage Captain"] = "鐵怒上尉",
    ["Anvilrage Marshal"] = "鐵怒隊長",
    ["Doomforge Arcanasmith"] = "末日之爐魔匠",
    ["Weapon Technician"] = "武器技師",
    ["Doomforge Craftsman"] = "末日之爐工匠",
    ["Murk Worm"] = "黑暗蟲",
    ["Atal'ai Witch Doctor"] = "阿塔萊巫醫",
    ["Raging Skeleton"] = "狂怒的骸骨",
    ["Ethereal Priest"] = "伊斯利牧師",
    ["Sethekk Ravenguard"] = "塞司克烏鴉護衛",
    ["Time-Lost Shadowmage"] = "時光流逝暗影法師",
    ["Coilfang Sorceress"] = "盤牙法師",
    ["Coilfang Oracle"] = "盤牙神諭者",
    ["Shattered Hand Centurion"] = "破碎之手百夫長",
    ["Eredar Deathbringer"] = "埃雷達爾死亡召喚者",
    ["Arcatraz Sentinel"] = "亞克崔茲哨兵",
    ["Gargantuan Abyssal"] = "巨型冥淵火",
    ["Sunseeker Botanist"] = "尋日植物學家",
    ["Sunseeker Astromage"] = "尋日星法師",
    ["Durnholde Rifleman"] = "敦霍爾德槍手",
    ["Rift Keeper/Rift Lord"] = "裂縫看守者 / 裂縫領主",
    ["Crimson Templar"] = "赤紅聖殿騎士",
    ["Azure Templar"] = "碧藍聖殿騎士",
    ["Hoary Templar"] = "蒼白聖殿騎士",
    ["Earthen Templar"] = "土色聖殿騎士",
    ["The Duke of Cynders"] = "辛德爾公爵",
    ["The Duke of Fathoms"] = "深淵公爵",
    ["The Duke of Zephyrs"] = "微風公爵",
    ["The Duke of Shards"] = "碎石公爵",
    ["Prince Skaldrenox"] = "斯卡德諾克斯王子",
    ["Aether-tech Assistan"] = "蒼穹技師助手",
    ["Aether-tech Adept"] = "蒼穹技師專家",
    ["Aether-tech Master"] = "蒼穹技師大師",

    --Zones
    ["World Drop"] = "世界掉落",

    --Chests, etc
    ["Chest of The Seven"] = "七賢者之箱",
    ["Dark Coffer"] = "黑色寶庫",
    ["The Secret Safe"] = "隱密的保險箱",
    ["The Vault"] = "寶窟",
    ["Ogre Tannin Basket"] = "巨魔鞣酸籃",
    ["Fengus's Chest"] = "衛兵芬古斯的箱子",
    ["The Prince's Chest"] = "王子的箱子",
    ["Doan's Strongbox"] = "杜安的箱子",
    ["Frostwhisper's Embalming Fluid"] = "萊斯·霜語的防腐液",
    ["Unforged Rune Covered Breastplate"] = "未鑄造的符文覆飾胸甲",
    ["Malor's Strongbox"] = "瑪洛爾的箱子",
    ["Unfinished Painting"] = "未完成的畫作",
    ["Felvine Shard"] = "魔藤碎片",
    ["Baelog's Chest"] = "巴爾洛戈的箱子",
    ["Lorgalis Manuscript"] = "洛迦里斯手稿",
    ["Fathom Core"] = "深淵之核",
    
    
} end)
--end
